/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.LogoJMenuItem;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.ConnectionConfigurePanel;
import DE.siemens.ad.logo.dialog.comp.IPAddressJTextField;
import DE.siemens.ad.logo.dialog.comp.SubnetMaskJTextField;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.NetworkConfiguration;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EthernetConfigurePanel
extends DataInputPanel {
    private BorderJPanel fAddressPanel;
    private IPAddressJTextField fIPAddressJTextField;
    private IPAddressJTextField fSubnetMaskJTextField;
    private IPAddressJTextField fGatewayJTextField;
    private BorderJPanel fConnectionPanel;
    private LogoDrawing fLogoDrawing = (LogoDrawing)Application.getInstance().getActiveApplicationSurface().getEditor().getView().getModel();
    private Hardware fHardware = this.fLogoDrawing.getWiringDiagram().getHardware();
    private ConnectionTree fConTree;
    private Vector<EthernetConnection> fDataVector;
    private ConnectionConfigurePanel fConConfigPanel;
    private static final int TSAP_INITIA_VALUE = 32;

    public EthernetConfigurePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setName(Language.getString("ethernet.ethernetConfigurePanel.title"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 0, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.getAddressPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)this.getConnectionPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        this.add((Component)new JPanel(), constraints);
    }

    private BorderJPanel getAddressPanel() {
        if (this.fAddressPanel == null) {
            this.fAddressPanel = new BorderJPanel(new GridBagLayout());
            this.fAddressPanel.setTitle(Language.getString("ethernet.ethernetConfigurePanel.addressPanel"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 10, 10, 10);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fAddressPanel.add((Component)new JLabel(Language.getString("ethernet.ethernetConfigurePanel.ipAddressPanel") + ": "), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.fIPAddressJTextField = new IPAddressJTextField();
            this.fAddressPanel.add((Component)this.fIPAddressJTextField, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.fAddressPanel.add((Component)new JLabel(Language.getString("ethernet.ethernetConfigurePanel.subnetMask")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            this.fSubnetMaskJTextField = new SubnetMaskJTextField();
            this.fSubnetMaskJTextField.setMaxFirstSegmentValue(255);
            this.fAddressPanel.add((Component)this.fSubnetMaskJTextField, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.fAddressPanel.add((Component)new JLabel(Language.getString("ethernet.ethernetConfigurePanel.gatewayMask")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            this.fGatewayJTextField = new IPAddressJTextField();
            this.fAddressPanel.add((Component)this.fGatewayJTextField, constraints);
        }
        return this.fAddressPanel;
    }

    private BorderJPanel getConnectionPanel() {
        if (this.fConnectionPanel == null) {
            this.fConnectionPanel = new BorderJPanel(new GridBagLayout());
            this.fConnectionPanel.setTitle(Language.getString("ethernet.ethernetConfigurePanel.connectionTitle"));
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(Language.getString("extra.ethernet.connections", "Ethernet Connections"));
            this.fConTree = new ConnectionTree(rootNode);
            this.fConTree.setCellRenderer(new ConnectionCellRenderer());
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(255, 155));
            scrollPane.setWheelScrollingEnabled(true);
            scrollPane.setViewportView(this.fConTree);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 5, 5, 0);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            this.fConnectionPanel.add((Component)scrollPane, constraints);
        }
        return this.fConnectionPanel;
    }

    @Override
    public boolean checkFieldContents() {
        if (this.fIPAddressJTextField.getIP().equals("") && this.fGatewayJTextField.getIP().equals("") && this.fSubnetMaskJTextField.getIP().equals("") && this.fDataVector.size() == 0) {
            return true;
        }
        if (!(IPAddressJTextField.isIPAddressLegal(this.fIPAddressJTextField.getIP()) && IPAddressJTextField.isIPAddressLegal(this.fSubnetMaskJTextField.getIP()) && (Util.isEmptyString(this.fGatewayJTextField.getIP()) || this.fGatewayJTextField.getIP().equals("   .   .   .   ") || IPAddressJTextField.isIPAddressLegal(this.fGatewayJTextField.getIP())))) {
            new LogoError(null, "ethernet.ethernetConfigurePanel.wrongAddress", "Please enter a valid IP.", 2, 0).display();
            return false;
        }
        if (!SubnetMaskJTextField.isSubnetLegal(this.fSubnetMaskJTextField.getIP())) {
            new LogoError(null, "panel.ip.msg.invalidSubnetMask", "The subnet mask is not valid. Check the value to make sure it was entered correctly.", 2, 0).display();
            return false;
        }
        for (EthernetConnection connection : this.fDataVector) {
            if (connection.isNotCreateByUser()) continue;
            if (connection.getRemoteTsap() == null) {
                Object[] info = new Object[]{connection.getID()};
                new LogoError(null, "ethernet.ethernetConfigurePanel.noInformation", "Please complete the information in connection.", info, 2, 0).display();
                return false;
            }
            if (connection.getRemoteIP() != null && connection.getRemoteIP().equals(this.fIPAddressJTextField.getIP())) {
                String targetRemote = Language.getString("dialog.options.color.connection", "Connection") + String.valueOf(connection.getID());
                Object[] info = new Object[]{targetRemote};
                new LogoError(null, "ethernet.ethernetConfigurePanel.moduleIpConflictWithServerIp", "The module IP address can't be the same as the sever IP address.", info, 2, 0).display();
                return false;
            }
            if (connection.getAcceptedIP() == null || !connection.getAcceptedIP().equals(this.fIPAddressJTextField.getIP())) continue;
            String targetRemote = Language.getString("dialog.options.color.connection", "Connection") + String.valueOf(connection.getID());
            Object[] info = new Object[]{targetRemote};
            new LogoError(null, "ethernet.ethernetConfigurePanel.moduleIpConflictWithAcceptIp", "The module IP address can't be the same as the accept IP address.", info, 2, 0).display();
            return false;
        }
        return super.checkFieldContents();
    }

    @Override
    public void loadFieldContents() {
        NetworkConfiguration networkInfo = this.fLogoDrawing.getWiringDiagram().getNetworkInfo();
        this.fIPAddressJTextField.setIP(networkInfo.getIPAddress());
        this.fSubnetMaskJTextField.setIP(networkInfo.getSubnetMask());
        this.fGatewayJTextField.setIP(networkInfo.getGateWay());
        this.fDataVector = (Vector)Util.deepCopy(networkInfo.getEthernetConnections());
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.fConTree.getModel().getRoot();
        rootNode.removeAllChildren();
        for (EthernetConnection connection : this.fDataVector) {
            rootNode.add(new DefaultMutableTreeNode(connection));
        }
        ((DefaultTreeModel)this.fConTree.getModel()).nodeStructureChanged(rootNode);
        this.fConTree.updateUI();
    }

    @Override
    public void storeFieldContents() {
        NetworkConfiguration networkInfo = this.fLogoDrawing.getWiringDiagram().getNetworkInfo();
        networkInfo.setIPAddress(this.fIPAddressJTextField.getIP());
        networkInfo.setSubnetMask(this.fSubnetMaskJTextField.getIP());
        networkInfo.setGateWay(this.fGatewayJTextField.getIP());
        networkInfo.setEthernetConnections(this.fDataVector);
        this.fLogoDrawing.setModified(true);
    }

    private ConnectionConfigurePanel getConConfigPanel(EthernetConnection connection) {
        if (this.fConConfigPanel == null) {
            this.fConConfigPanel = new ConnectionConfigurePanel(connection, this.fDataVector, this.fLogoDrawing.getWiringDiagram().getHardware(), this.fIPAddressJTextField.getIP());
            return this.fConConfigPanel;
        }
        this.fConConfigPanel.setEthernetConnection(connection, this.fDataVector, this.fIPAddressJTextField.getIP());
        return this.fConConfigPanel;
    }

    public static int getFreeConnectionID(Vector<EthernetConnection> connections, int maximumConnNumber) {
        int i = 1;
        boolean avilable = true;
        do {
            avilable = true;
            for (EthernetConnection conn : connections) {
                if (conn.getID() != i) continue;
                ++i;
                avilable = false;
                break;
            }
            if (i <= maximumConnNumber) continue;
            return -1;
        } while (!avilable);
        return i;
    }

    public static String getFreeLocalTsap(Vector<EthernetConnection> connections) {
        String ret = "";
        int i = 0;
        boolean avilable = true;
        block0: do {
            avilable = true;
            ret = Integer.toHexString(32 + i) + ".00";
            for (EthernetConnection connection : connections) {
                if (!ret.equalsIgnoreCase(connection.getLocalTsap())) continue;
                ++i;
                avilable = false;
                continue block0;
            }
        } while (!avilable);
        return ret;
    }

    protected class ConnectionCellRenderer
    extends DefaultTreeCellRenderer {
        private int fRowHeight = 16;
        private Color fDefaultSelectionColor = this.getBackgroundSelectionColor();

        public Dimension getPreferredSize() {
            return new Dimension(210, 16);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof EthernetConnection) {
                ImageIcon icon;
                EthernetConnection conn = (EthernetConnection)((DefaultMutableTreeNode)value).getUserObject();
                this.setFont(new JLabel().getFont());
                this.setText(conn.toString());
                int rowHeight = tree.getRowHeight();
                if (rowHeight <= 0) {
                    rowHeight = this.fRowHeight;
                }
                if ((icon = Global.getIcon("Connection.gif")).getIconHeight() != rowHeight) {
                    int unscaledHeight = icon.getIconHeight();
                    float scale = (float)rowHeight / (float)unscaledHeight;
                    icon = new ImageIcon(icon.getImage().getScaledInstance((int)((float)icon.getIconWidth() * scale), (int)((float)icon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
                }
                this.setIcon(icon);
                if (selected) {
                    this.setBackgroundSelectionColor(this.fDefaultSelectionColor);
                }
                if (conn.isNotCreateByUser()) {
                    this.setEnabled(false);
                }
            } else {
                this.setIcon(Global.getIcon("Ethernet.gif"));
            }
            return this;
        }
    }

    class ConnectionTree
    extends JTree {
        private DefaultMutableTreeNode fSelectedNode;
        private LogoJPopupMenu fPopupMenu;

        public ConnectionTree(TreeNode root) {
            super(root);
            this.setShowsRootHandles(true);
            this.addMouseListener(new ConnectionTreeMouseAdapter());
            this.addKeyListener(new ConnectionTreeKeyAdapter());
        }

        private JPopupMenu getPopMenu() {
            if (this.fPopupMenu == null) {
                this.fPopupMenu = new LogoJPopupMenu();
            }
            this.fPopupMenu.removeAll();
            this.fSelectedNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (this.fSelectedNode.getUserObject() instanceof EthernetConnection) {
                LogoJMenuItem deleteItem = new LogoJMenuItem(Language.getString("ethernet.ethernetConfigurePanel.removeConnection"));
                deleteItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConnectionTree.this.deleteConnection(((EthernetConnection)ConnectionTree.this.fSelectedNode.getUserObject()).getID());
                    }
                });
                if (!((EthernetConnection)this.fSelectedNode.getUserObject()).isNotCreateByUser()) {
                    this.fPopupMenu.add(deleteItem);
                }
            } else {
                LogoJMenuItem addConItem = new LogoJMenuItem(Language.getString("ethernet.ethernetConfigurePanel.addConnection"));
                addConItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConnectionTree.this.addConnection();
                    }
                });
                if (this.fSelectedNode.getChildCount() < EthernetConfigurePanel.this.fHardware.getIntProperty("maximumConnections")) {
                    this.fPopupMenu.add(addConItem);
                }
            }
            return this.fPopupMenu;
        }

        private void addConnection() {
            EthernetConnection conn = new EthernetConnection(EthernetConfigurePanel.getFreeConnectionID(EthernetConfigurePanel.this.fDataVector, EthernetConfigurePanel.this.fHardware.getIntProperty("maximumConnections")));
            EthernetConfigurePanel.this.fDataVector.add(conn);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(conn);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultTreeModel)EthernetConfigurePanel.this.fConTree.getModel()).getRoot();
            ((DefaultTreeModel)EthernetConfigurePanel.this.fConTree.getModel()).insertNodeInto(node, root, root.getChildCount());
            EthernetConfigurePanel.this.fConTree.updateUI();
        }

        private void deleteConnection(int connID) {
            Iterator connections = EthernetConfigurePanel.this.fDataVector.iterator();
            while (connections.hasNext()) {
                EthernetConnection conection = (EthernetConnection)connections.next();
                if (conection.getID() != connID) continue;
                connections.remove();
                ((DefaultTreeModel)EthernetConfigurePanel.this.fConTree.getModel()).removeNodeFromParent(this.fSelectedNode);
                EthernetConfigurePanel.this.fConTree.updateUI();
                return;
            }
        }

        class ConnectionTreeMouseAdapter
        extends MouseAdapter {
            ConnectionTreeMouseAdapter() {
            }

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                TreePath path = ConnectionTree.this.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                ConnectionTree.this.setSelectionPath(path);
                if (ConnectionTree.this.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ConnectionTree.this.getLastSelectedPathComponent();
                    ConnectionTree.this.fSelectedNode = selectedNode;
                }
                if (e.getClickCount() == 2 && ConnectionTree.this.fSelectedNode != null && ConnectionTree.this.fSelectedNode.getUserObject() instanceof EthernetConnection && !((EthernetConnection)ConnectionTree.this.fSelectedNode.getUserObject()).isNotCreateByUser()) {
                    SplittedDlg dialog = SplittedDlg.create(null, EthernetConfigurePanel.this.getConConfigPanel((EthernetConnection)ConnectionTree.this.fSelectedNode.getUserObject()), 11);
                    dialog.setVisible(true);
                }
            }

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                TreePath path = ConnectionTree.this.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                ConnectionTree.this.setSelectionPath(path);
                if (ConnectionTree.this.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ConnectionTree.this.getLastSelectedPathComponent();
                    ConnectionTree.this.fSelectedNode = selectedNode;
                }
                if (e.getButton() == 3) {
                    ConnectionTree.this.getPopMenu().show(EthernetConfigurePanel.this.fConTree, e.getX(), e.getY());
                }
            }
        }

        class ConnectionTreeKeyAdapter
        extends KeyAdapter {
            ConnectionTreeKeyAdapter() {
            }

            public void keyReleased(KeyEvent e) {
                DefaultMutableTreeNode root;
                if (e.getKeyCode() == 127) {
                    if (ConnectionTree.this.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ConnectionTree.this.getLastSelectedPathComponent();
                        ConnectionTree.this.fSelectedNode = selectedNode;
                    }
                    if (ConnectionTree.this.fSelectedNode.getUserObject() instanceof EthernetConnection) {
                        ConnectionTree.this.deleteConnection(((EthernetConnection)ConnectionTree.this.fSelectedNode.getUserObject()).getID());
                    }
                } else if (e.getKeyCode() == 155 && (root = (DefaultMutableTreeNode)((DefaultTreeModel)EthernetConfigurePanel.this.fConTree.getModel()).getRoot()).getChildCount() < EthernetConfigurePanel.this.fHardware.getIntProperty("maximumConnections")) {
                    ConnectionTree.this.addConnection();
                }
            }
        }
    }
}

